<?php
session_start();

// --- Configuration (Hardcoded for initial testing) ---
// IMPORTANT: In a production environment, this data must be fetched from the 'users' table 
// and the password must be compared using password_verify() against a hashed password.
$PRESELECTED_USERNAME = "admin";
$PRESELECTED_PASSWORD = "admin123";
// Assuming the user ID for this admin is 1 in the 'users' table for Foreign Key integrity
$PRESELECTED_USER_ID = 1; 

$login_message = '';
$message_class = '';

// --- Handle Logout Redirection Status ---
if (isset($_GET['status']) && $_GET['status'] === 'logged_out') {
    $login_message = "You have logged out successfully.";
    $message_class = 'success';
}


// --- Handle Login Attempt ---
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    // Hardcoded check
    if ($username === $PRESELECTED_USERNAME && $password === $PRESELECTED_PASSWORD) {
        // Successful login
        $_SESSION['admin_logged_in'] = true;
        // Store user details required for Foreign Key references (like general documents upload)
        $_SESSION['user_id'] = $PRESELECTED_USER_ID; 
        $_SESSION['username'] = $PRESELECTED_USERNAME; 
        
        header("Location: admin_dashboard.php");
        exit();
    } else {
        $login_message = "Invalid credentials. Please try again.";
        $message_class = 'error';
    }
}

// Redirect already logged-in users
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header("Location: admin_dashboard.php");
    exit();
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f7f9fb;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            height: 100vh;
            margin: 0;
        }
        .message {
            padding: 15px 25px;
            margin-bottom: 20px;
            border-radius: 8px;
            font-weight: bold;
            text-align: center;
            width: 90%;
            max-width: 400px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        .message.success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .message.error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .login-container {
            background-color: #ffffff;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
            text-align: center;
        }
        h1 {
            color: #2c3e50;
            margin-bottom: 30px;
            font-size: 28px;
        }
        label {
            display: block;
            text-align: left;
            margin-bottom: 5px;
            color: #34495e;
            font-weight: bold;
        }
        input[type="text"], input[type="password"] {
            width: 100%;
            padding: 12px;
            margin-bottom: 20px;
            border: 1px solid #e0e6ed;
            border-radius: 6px;
            box-sizing: border-box;
            transition: border-color 0.3s;
        }
        input[type="text"]:focus, input[type="password"]:focus {
            border-color: #3498db;
            outline: none;
        }
        button[type="submit"] {
            width: 100%;
            padding: 12px;
            background-color: #3498db;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s, transform 0.1s;
        }
        button[type="submit"]:hover {
            background-color: #2980b9;
        }
        button[type="submit"]:active {
            transform: translateY(1px);
        }
    </style>
</head>
<body>
    
    <?php if ($login_message): ?>
        <div class="message <?php echo $message_class; ?>">
            <?php echo htmlspecialchars($login_message); ?>
        </div>
    <?php endif; ?>

    <div class="login-container">
        <h1>Admin Login</h1>
        <form action="index.php" method="post">
            <label for="username">Username</label>
            <!-- Hardcoded value kept for easy testing, but remove in production -->
            <input type="text" name="username" id="username" required value="<?php echo $PRESELECTED_USERNAME; ?>">

            <label for="password">Password</label>
            <!-- Hardcoded value kept for easy testing, but remove in production -->
            <input type="password" name="password" id="password" required value="<?php echo $PRESELECTED_PASSWORD; ?>">
            
            <button type="submit">Log In</button>
        </form>
    </div>
</body>
</html>
